#ifndef DIS_H
#define DIS_H

typedef struct {
	UINT8  id[8];
	UINT32 text;			/* SCE only */
	UINT32 data;			/* SCE only */
	UINT32 pc0;
	UINT32 gp0;			/* SCE only */
	UINT32 t_addr;
	UINT32 t_size;
	UINT32 d_addr;			/* SCE only */
	UINT32 d_size;			/* SCE only */
	UINT32 b_addr;			/* SCE only */
	UINT32 b_size;			/* SCE only */
	UINT32 s_addr;
	UINT32 s_size;
	UINT32 SavedSP;
	UINT32 SavedFP;
	UINT32 SavedGP;
	UINT32 SavedRA;
	UINT32 SavedS0;
	UINT8  pad[2048-19*4];
} EXE_HEADER;

void watch(int num);
void watchcop(int num);
void disasm(char *buf, UINT32 code, UINT32 addr);

#endif
